# Girocard Branding SDK
## Introduction
Netcetera provides a lightweight iOS SDK that helps integrators to implement and play Girocard Sensory Branding confirmation. The SDK should be used when a Point of Interaction (POI) accepts the Girocard payment card or account, to assure the user via a multi-sensory confirmation.

In order to provide multi-sensory confirmation, the mandatory animation can be accompanied by any of the optional features that can be enabled through the configuration.

The iOS SDK supports the following optional features:
* Sound
* Vibration

#### Supported Versions
* iOS 14 and above

#### Supported Languages
* Swift
* Objective-C

#### Supported UI Frameworks
* UI Kit
* Swift UI

## Integration
The iOS Girocard Branding SDK can be integrated in an iOS application by adding the provided XCFramework in the "Frameworks, Libraries, and Embedded Content" section of the General target's tab.

## API
The public API for the `Girocard Branding SDK` is consisted of: `GirocardBrandingView` (and `GirocardBrandingSwitUIView` wrapper for SwiftUI), `GirocardBrandingConfiguration` and `GirocardBrandingService`.
### GirocardBrandingView
The `GirocardBrandingView` is used for presenting the Girocard multi-sensory confirmation. The integrators should create a GirocardBrandingView which should later be passed as a parameter in the `play(...)` method of the `GirocardBrandingService`.
#### UIKit
In UIKit, the `GirocardBrandingView` can either be created and added programatically:
```
viewController.view = GirocardBrandingView()
```
or through the utilisation of storyboards:
```
// IBOutlet of a previously added storyboard View with custom class GirocardBrandingView
@IBOutlet weak var girocardBrandingView: GirocardBrandingView!
```
#### SwiftUI
In SwiftUI, the `GirocardBrandingView` should be wrapped in `GirocardBrandingSwitUIView` when being presented.
```
let girocardBrandingView = GirocardBrandingView()
var body: some View {
  GirocardBrandingSwitUIView(view: girocardBrandingView)
}
```
### Configuration
The configuration for the Girocard Branding SDK is provided via `GirocardBrandingConfiguration` with the following arguments:

| Parameter        | Description                                                                                          |
| ---------------- | ---------------------------------------------------------------------------------------------------- |
| includeSound     | Boolean value which defines if sound should be included during the multi-sensory confirmation.       |
| useVibration     | Boolean value which defines if vibration should be included during the multi-sensory confirmation.   |

The `GirocardBrandingConfiguration` should be passed as a parameter in the `play(...)` method of the `GirocardBrandingService`.

### GirocardBrandingService
The `GirocardBrandingService` offers the main functionalities of the SDK.
#### Initialize
Prior to its usage, the `GirocardBrandingService` should first be initialized.
```
let girocardBrandingService: GirocardBrandingService = GirocardBrandingServiceLogic()
```
#### Play a multi-sensory confirmation
Once the service is successfully initialized, invoke `play(...)` to play a Girocard multi-sensory confirmation.
```
girocardBrandingService.play(in: girocardBrandingView, configuration: girocardBrandingConfiguration) {
    // Handle successful completion of the multi-sensory confirmation
} failure: { girocardError in
    // Handle runtime error that has occurred in the Girocard Branding SDK
}
```
