import UIKit
import Girocard_Branding_SDK

class ViewController: UIViewController {
    
    @IBOutlet weak var includeSound: UISwitch!
    @IBOutlet weak var useVibration: UISwitch!
    @IBOutlet weak var girocardBrandingView: GirocardBrandingView!
    
    let girocardBrandingService: GirocardBrandingService = GirocardBrandingServiceLogic()
    
    @IBAction func play(_ sender: Any) {
        girocardBrandingService.play(in: girocardBrandingView,
                                    configuration: girocardConfig()) {
            print("success")
        } failure: { girocardError in
            print("failure with error: [\(girocardError.code)] \(girocardError.localizedDescription)")
        }
    }
    
    @IBAction func playFullscreen(_ sender: Any) {
        let fullScreenViewController = UIViewController()
        fullScreenViewController.modalPresentationStyle = .fullScreen
        fullScreenViewController.view = GirocardBrandingView()
        fullScreenViewController.view.backgroundColor = UIColor.white
        
        present(fullScreenViewController, animated: true) {
            self.girocardBrandingService.play(in: fullScreenViewController.view as! GirocardBrandingView,
                                             configuration: self.girocardConfig()) {
                print("success")
                fullScreenViewController.dismiss(animated: true)
            } failure: { girocardError in
                print("failure with error: [\(girocardError.code)] \(girocardError.description)")
                fullScreenViewController.dismiss(animated: true)
            }
        }
    }
    
    func girocardConfig() -> GirocardBrandingConfiguration {
        return GirocardBrandingConfiguration(includeSound: includeSound.isOn,
                                            useVibration: useVibration.isOn)
    }
}

