import Foundation

/// Service used for playing animations.
protocol AnimationService {
    
    /// Plays an animation according to the configuration.
    /// - Parameters:
    ///   - view: The view in which the animation will be played.
    ///   - configuration: A configuration according to which the animation will be played.
    ///   - animationStarted: A callback called when the animation has started playing.
    ///   - success: A callback called when the animation has finished playing successfully.
    ///   - failure: A callback called when an error has occurred during the process of playing the animation.
    func play(view: GirocardBrandingView,
              configuration: GirocardBrandingConfiguration,
              animationStarted: @escaping () -> (),
              success: @escaping () -> (),
              failure: @escaping (GirocardError) -> ())
    
    /// Cleans up the resources used for playing an animation.
    func cleanUp()
}
