import Foundation

/// Provides an API to the Girocard Sensory Branding Services.
@objc
public protocol GirocardBrandingService {
    
    /// Displays a Girocard multi-sensory confirmation.
    /// - Parameters:
    ///   - view: The view in which the Girocard multi-sensory confirmation will be displayed.
    ///   - configuration: A configuration according to which the Girocard multi-sensory confirmation will be displayed.
    ///   - success: A callback called when the Girocard multi-sensory confirmation has finished displaying successfully.
    ///   - failure: A callback called when an error has occurred during the process of displaying the Girocard multi-sensory confirmation.
    func play(in view: GirocardBrandingView,
              configuration: GirocardBrandingConfiguration,
              success: @escaping () -> (),
              failure: @escaping (NSError) -> ())
}
