import Foundation

@objcMembers
public class GirocardBrandingServiceLogic: NSObject, GirocardBrandingService {
    private let animationService = AnimationServiceLogic()
    private let hapticFeedbackService = HapticFeedbackServiceLogic()
    
    public func play(in view: GirocardBrandingView,
                     configuration: GirocardBrandingConfiguration,
                     success: @escaping () -> (),
                     failure: @escaping (NSError) -> ()) {
        animationService.play(view: view,
                              configuration: configuration) {
            if configuration.useVibration {
                self.hapticFeedbackService.vibrate(with: PredefinedResources.vibrationPattern)
            }
        } success: {
            Logger.infoLog(message: "Girocard branding finished playing successfully.")
            success()
            self.cleanUp()
        } failure: { girocardError in
            switch girocardError {
            case .runtimeError(let errorCode, let description):
                Logger.errorLog(message: "[\(errorCode)] \(description)")
                let error = NSError(domain: PredefinedResources.domain,
                                    code: errorCode,
                                    userInfo: [NSLocalizedDescriptionKey: description])
                failure(error)
                
                if errorCode != GirocardErrorCode.animationAlreadyPlaying.rawValue {
                    self.cleanUp()
                }
            }
        }
    }
    
    private func cleanUp() {
        animationService.cleanUp()
        hapticFeedbackService.cleanUp()
    }
}
