import UIKit
import SwiftUI

/// Custom Girocard Branding View
@objcMembers
public class GirocardBrandingView: UIView {
    var videoLayer: CALayer?
    
    public override func layoutSubviews() {
        videoLayer?.frame = self.bounds
    }
    
    func addLayer(_ layer: CALayer) {
        videoLayer = layer
        self.layer.addSublayer(layer)
    }
    
    func removeLayers() {
        videoLayer?.removeFromSuperlayer()
    }
}

/// Girocard Branding View Wrapper used for Swift UI
public struct GirocardBrandingSwitUIView: UIViewRepresentable {
    var view: GirocardBrandingView
    
    public init(view: GirocardBrandingView) {
        self.view = view
    }
    
    public func makeUIView(context: Context) -> UIView {
        return view
    }
    
    public func updateUIView(_ uiView: UIView, context: Context) {
    }
}
