import Foundation

/// Configuration class for the Girocard multi-sensory confirmation.
@objcMembers
public class GirocardBrandingConfiguration: NSObject {
    let includeSound: Bool
    let useVibration: Bool

    /// Girocard Branding Configuration initializer.
    /// - Parameters:
    ///   - includeSound: Boolean value which defines if sound should be included during the multi-sensory confirmation.
    ///   - useVibration: Boolean value which defines if vibration should be included during the multi-sensory confirmation.
    public init(includeSound: Bool,
                useVibration: Bool) {
        self.includeSound = includeSound
        self.useVibration = useVibration
    }
}
