import Foundation

/// Service used for playing haptic feedback.
protocol HapticFeedbackService {
    /// Plays a vibration according to the pattern.
    /// - Parameter pattern: Pattern according to which the haptic feedback will be played.
    func vibrate(with pattern: VibrationPattern)
    
    /// Cleans up the resources used for playing a haptic feedback.
    func cleanUp()
}

/// Holds properties used for defining a vibration pattern.
struct VibrationPattern {
    let timings: [Int]
    let amplitudes: [Int]
}
