import Foundation

enum GirocardError: Error {
    case runtimeError(errorCode: Int, description: String)
}

enum GirocardErrorCode: Int {
    case animationAlreadyPlaying = 101
    case resourcesMissing = 102
    case animationPlayerFailure = 103
}

extension GirocardErrorCode {
    var description: String {
        switch self {
        case .animationAlreadyPlaying:
            "An animation is already playing."
        case .resourcesMissing:
            "Required resources are missing."
        case .animationPlayerFailure:
            "An issue occurred while playing the animation."
        }
    }
}
